#include "timing.h"

void Timing_Reset(TIMING *pTiming)
{
	pTiming->NumTimings = 0;
	pTiming->LastWriteIndex = 0;
	pTiming->MinTime = 0;
	pTiming->MaxTime = 0;
	pTiming->CumulativeTime = 0;
}


void Timing_Update(TIMING *pTiming, uint32_t Time)
{
	uint32_t WriteIndex;

	/* update min and max */
	if (Time < pTiming->MinTime)
	{
		pTiming->MinTime = Time;
	}
	else if (Time > pTiming->MaxTime)
	{
		pTiming->MaxTime = Time;
	
	}

	/* update index */
	WriteIndex = pTiming->LastWriteIndex;
	WriteIndex++;
	if (WriteIndex >= MAX_TIMINGS)
	{
		WriteIndex = 0;
	}
	pTiming->LastWriteIndex = WriteIndex;
	
	/* remove a timing from the cumulative timings */
	if (pTiming->NumTimings == MAX_TIMINGS)
	{
		/* this is the one being replaced and also the oldest */
		pTiming->CumulativeTime -= pTiming->Timings[WriteIndex];
	}
	else
	{
		pTiming->NumTimings++;
	}

	/* store this */
	pTiming->Timings[WriteIndex] = Time;
	/* and update cumulative */
	pTiming->CumulativeTime += Time;
}

uint32_t Timing_GetMinTime(TIMING *pTiming)
{
	return pTiming->MinTime;
}

uint32_t Timing_GetMaxTime(TIMING *pTiming)
{
	return pTiming->MaxTime;
}

uint32_t Timing_HasTimings(TIMING *pTiming)
{
	return pTiming->NumTimings!=0;
}

uint32_t Timing_GetAverageTime(TIMING *pTiming)
{
	uint32_t NumTimings = pTiming->NumTimings;
	
	if (NumTimings == 0)
		return 0;

	return (pTiming->CumulativeTime / NumTimings)&0x0ffffffff;
}

